﻿using System;
using System.IO;
using System.Collections;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Drawing;
using System.Linq;
using System.Text;
using GTA;

#if USING_XBOX_PAD
    using Microsoft.Xna.Framework.Input;
#endif

namespace NomeScripts
{
    public class BikeNBat : Script
    {
#if USING_XBOX_PAD
        X360Pad pad;
#else
        GTAKeyboard keyboardInput;
#endif
        /// <summary>
        /// To handle bike animations, and choosing the right animations when swinging the bat
        /// </summary>
        SwingBat swingBat;        

        public BikeNBat()
        {
            Interval = 1;

            // Create SwingBat object with the player
            swingBat = new SwingBat(Player.Character);

#if USING_XBOX_PAD
            // Create input
            pad = new X360Pad(1);

            if (!LoadSettings())
            {
                Game.Console.Print("BikeNBat: There is an error with the ini file settings, if there is no previous error above this message it must be the [Settings]");
                Game.Console.Print("BikeNBat: Rectify the issue, and reloadscripts");
            } else {
                if (pad.CurrentState.IsConnected)
                {
                    this.Tick += new EventHandler(ControllerInput_Tick);
                    this.Tick += new EventHandler(swingBat.Update);  
                }
            }
#else
            keyboardInput = new GTAKeyboard();

            if (!LoadSettings())
            {
                Game.Console.Print("BikeNBat: There is an error with the ini file settings, if there is no previous error above this message it must be the [Settings]");
                Game.Console.Print("BikeNBat: Rectify the issue, and reloadscripts");
            } else {
                this.Tick += new EventHandler(BikeNBat_Tick);
                this.KeyDown += new GTA.KeyEventHandler(BikeNBat_KeyDown);
                this.KeyUp += new GTA.KeyEventHandler(BikeNBat_KeyUp);
                this.Tick += new EventHandler(swingBat.Update);
            }
#endif
        }

        private bool LoadSettings()
        {
            // Get the directory of the ini file
            int index = Filename.LastIndexOf("\\");
            String dir = Filename.Remove(index);

            // Load settings file
            IniFile settings = new IniFile(dir + "\\BikeNBat.ini");

            // Get disableCinematicAndHeadLightButton value
            bool disCHL = false;
            if (!settings.GetValueFromIni(ref disCHL, "Settings", "DisableCinematicAndHeadLightButton")) return false;
            swingBat.disableCiniAndHL = disCHL;

            // Get UseSetStrength value
            bool uss = false;
            if (!settings.GetValueFromIni(ref uss, "Settings", "UseSetStrength")) return false;
            swingBat.useSetStrength = uss;

            // Get UseSetStrength value
            bool spof = false;
            if (!settings.GetValueFromIni(ref spof, "Settings", "SetPedsOnFire")) return false;
            swingBat.setPedsOnFire = spof;

            // Get charge time and set on fire time
            int chargeTime = 0;
            int fireTime = 0;
            if (!settings.GetValueFromIni(ref chargeTime, "Settings", "TimeToCharge")) return false;
            if (!settings.GetValueFromIni(ref fireTime, "Settings", "TimeToSetOnFire")) return false;
            swingBat.SetTiming(chargeTime, fireTime);

#if USING_XBOX_PAD
            if (!pad.LoadButtons(settings, new KeyValuePair<string, InputDelegate>("SwingRight", swingBat.SwingRight),
                                           new KeyValuePair<string, InputDelegate>("SwingLeft", swingBat.SwingLeft)))
            {
                Game.Console.Print("BikeNBat: XBOX buttons invalid");
                return false;
            }
#else
            // Keybindings
            if (!keyboardInput.LoadKeys(settings,
                                        new KeyValuePair<string, InputDelegate>("SwingRight", swingBat.SwingRight),
                                        new KeyValuePair<string, InputDelegate>("SwingLeft", swingBat.SwingLeft)))
            {
                Game.Console.Print("BikeNBat: Keyboard buttons invalid");
                return false;
            }
#endif
            return true;
        }

#if USING_XBOX_PAD
        /// <summary>
        /// Update the controller input
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void ControllerInput_Tick(object sender, EventArgs e)
        {
            // Check there is no input from the controller
            // and the bat charger timer is running
            if (!pad.UpdateInput() &&
                swingBat.ChargerTimer.isRunning)
            {
                // Stop the bat charging up
                swingBat.ChargerTimer.Stop();
            }
        }
#else
        private void BikeNBat_Tick(object sender, EventArgs e)
        {
            if (!keyboardInput.isKeysDown())
            {
                // Stop the bat charging up
                swingBat.ChargerTimer.Stop();
            }
        }

        private void BikeNBat_KeyUp(object sender, GTA.KeyEventArgs e)
        {
            if (keyboardInput.KeyMapping.ContainsKey(e.KeyWithModifiers) &&
                swingBat.ChargerTimer.isRunning)
            {
                keyboardInput.SetKeyUp(e.KeyWithModifiers);
            }
        }

        private void BikeNBat_KeyDown(object sender, GTA.KeyEventArgs e)
        {
            if (keyboardInput.KeyMapping.ContainsKey(e.KeyWithModifiers))
            {
                // Call delegate
                keyboardInput.KeyMapping[e.KeyWithModifiers]();
                keyboardInput.SetKeyDown(e.KeyWithModifiers);
            }
        }
#endif
    }
}